﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Logs
{
    using Projects;

    public class WarningLine : OutputLine
    {
        public WarningLine(string text)
            : base(OutputLevel.Warning, text)
        {
        }

        public WarningLine(string text, Component component)
            : base(OutputLevel.Warning, text, component)
        {
        }

        public WarningLine(string text, params Component[] components)
            : base(OutputLevel.Warning, text, components)
        {
        }

        protected override string Header
        {
            get
            {
                string targetComponentName = this.GetTargetComponentName();

                if (targetComponentName.Length == 0)
                {
                    return Resources.MessageResource.MessageHeader_Warning_General;
                }

                return string.Format(
                    Resources.MessageResource.MessageHeader_Warning_GeneralWithName,
                    targetComponentName);
            }
        }
    }
}
