﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.Wave
{
    using System;
    using System.Collections.Generic;

    public class WaveFileFormatException : Exception
    {
        public WaveFileFormatException(string s) : base(s) { }
    }

    public abstract class WaveFile
    {
        public interface IRegionInfo
        {
            string Name { get; }
            uint StartFrame { get; set; }
            uint EndFrame { get; set; }
        }

        public interface IMarkerInfo
        {
            string Name { get; }
            uint Position { get; set; }
        }

        public abstract int ChannelCount { get; set; }
        public abstract long FrameCount { get; set; }
        public abstract int SampleBit { get; set; }
        public abstract int SampleRate { get; set; }
        public abstract int OriginalKey { get; set; }

        public abstract double WaveTime { get; set; } // 単位は、ミリ秒です。

        public abstract bool IsLoop { get; }
        public abstract long LoopStartFrame { get; set; }
        public abstract long LoopEndFrame { get; set; }

        public abstract IList<IRegionInfo> Regions { get; }

        public abstract IList<IMarkerInfo> Markers { get; }
    }
}
