﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Xml;
    using System.Xml.Serialization;
    using Projects;
    using ToolDevelopmentKit.Conversion;

    [Serializable]
    [XmlRoot("SoundListOutput", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlSoundListOutput
    {
        public XmlSoundListOutput()
        {
            this.OutputType = SoundListOutputType.EachSoundSet.ToText();
            this.ListOutputs = new List<XmlListOutput>();
        }

        [XmlAttribute("Name")]
        public string Name { get; set; }

        [XmlAttribute("Title")]
        public string Title { get; set; }

        [XmlAttribute("FilePath")]
        public string FilePath { get; set; }

        [XmlAttribute("OutputType")]
        public string OutputType { get; set; }

        [XmlAttribute("IsIgnoreDisableItems")]
        public bool IsIgnoreDisableItems { get; set; }

        [XmlArray("ListOutputs")]
        [XmlArrayItem("ListOutput", Type = typeof(XmlListOutput))]
        [Overwrite(OverwriteAttribute.KindType.ListSet)]
        public List<XmlListOutput> ListOutputs { get; set; }
    }
}
