﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("ProjectSoundSet", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlProjectSoundSet
    {
        [XmlAttribute("Name")]
        public string Name { get; set; }

        [XmlArray("Parameters")]
        // プロジェクトサウンドセットパラメータ
        [XmlArrayItem(XmlParameterNames.FilePath, Type = typeof(XmlFilePathParam))]
        // コンポーネントパラメータ
        [XmlArrayItem(XmlParameterNames.ColorIndex, Type = typeof(XmlColorIndexParam))]
        [XmlArrayItem(XmlParameterNames.Comment, Type = typeof(XmlCommentParam))]
        [XmlArrayItem(XmlParameterNames.IsEnabled, Type = typeof(XmlIsEnabledParam))]
        // カスタムパラメータ
        [XmlArrayItem(XmlParameterNames.Custom.Bool, Type = typeof(XmlBoolParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Float, Type = typeof(XmlFloatParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Int, Type = typeof(XmlIntParam))]
        [XmlArrayItem(XmlParameterNames.Custom.String, Type = typeof(XmlStringParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Uint, Type = typeof(XmlUintParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Ulong, Type = typeof(XmlUlongParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Xml, Type = typeof(XmlXmlParam))]
        [XmlArrayItem(XmlParameterNames.Custom.ItemReference, Type = typeof(XmlItemReferenceParam))]
        public List<XmlParameter> Parameters { get; set; }
    }
}
