﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;
    using ToolDevelopmentKit;

    [Serializable]
    [XmlRoot(
        "Sound3D",
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlSound3DParam : XmlParameter, IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // 3Dサウンドパラメータ
        [XmlArrayItem("DecayCurve3D", Type = typeof(XmlDecayCurve3DParam))]
        [XmlArrayItem("DecayRatio3D", Type = typeof(XmlDecayRatio3DParam))]
        [XmlArrayItem("DopplerFactor3D", Type = typeof(XmlDopplerFactor3DParam))]
        [XmlArrayItem("Enable3DFilter", Type = typeof(XmlEnable3DFilterParam))]
        [XmlArrayItem("Enable3DPan", Type = typeof(XmlEnable3DPanParam))]
        [XmlArrayItem("Enable3DPriority", Type = typeof(XmlEnable3DPriorityParam))]
        [XmlArrayItem("Enable3DSurroundPan", Type = typeof(XmlEnable3DSurroundPanParam))]
        [XmlArrayItem("Enable3DVolume", Type = typeof(XmlEnable3DVolumeParam))]
        public List<XmlParameter> Parameters
        {
            get { return this.XmlValue as List<XmlParameter>; }
            set { this.XmlValue = value; }
        }

        /// <summary>
        /// Name属性は定義しません。
        /// </summary>
        [XmlIgnore]
        public override bool NameSpecified
        {
            get { return false; }
        }

        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.Sound3DParams;
        }

        protected override object ValidateXmlValue(object value)
        {
            Ensure.Argument.True(value is List<XmlParameter>);
            return value;
        }
    }
}
