﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot(
        "Parameter",
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public abstract class XmlParameter
    {
        private string name;
        private object xmlValue;

        protected XmlParameter()
        {
            this.name = ValidateName(string.Empty);
        }

        [XmlAttribute("Name")]
        public string Name
        {
            get { return this.name; }
            set { this.name = this.ValidateName(value); }
        }

        /// <summary>
        /// Name属性を定義するかどうかを取得します。
        /// </summary>
        /// <remarks>
        /// 派生クラスでオーバーライドし false を返すことで
        /// 名前を定義しないようにすることができます。
        /// </remarks>
        [XmlIgnore]
        public virtual bool NameSpecified
        {
            get { return true; }
        }

        [XmlIgnore]
        public object XmlValue
        {
            get { return this.xmlValue; }
            set { this.xmlValue = this.ValidateXmlValue(value); }
        }

        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected virtual string ValidateName(string name)
        {
            return name;
        }

        /// <summary>
        /// 値を検証し有効化します。
        /// </summary>
        /// <param name="value">値を指定します。</param>
        /// <returns>有効化された値を返します。</returns>
        protected virtual object ValidateXmlValue(object value)
        {
            return value;
        }
    }
}
