﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;

    internal class SoundProjectItemParamTranslator : CommonItemParamTranslator
    {
        public SoundProjectItemParamTranslator()
        {
            // サウンドアーカイブプレイヤー設定
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.SequenceSoundCount, typeof(XmlSoundArchivePlayerSequenceSoundCountParam));
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.SequenceTrackCount, typeof(XmlSoundArchivePlayerSequenceTrackCountParam));
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.StreamChannelCount, typeof(XmlSoundArchivePlayerStreamChannelCountParam));
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.StreamBufferTimes, typeof(XmlSoundArchivePlayerStreamBufferTimesParam));
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.StreamSoundCount, typeof(XmlSoundArchivePlayerStreamSoundCountParam));
            this.AddHandler(ProjectParameterNames.SoundArchivePlayer.WaveSoundCount, typeof(XmlSoundArchivePlayerWaveSoundCountParam));

            // コンバート設定
            this.AddHandler(ProjectParameterNames.Conversion.DoWarnUnreferencedItems, typeof(XmlDoWarnUnreferencedItemsParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoWarnDisableGroupItemTargets, typeof(XmlDoWarnDisableGroupItemTargetsParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoWarnPCBinariesForAACNotFound, typeof(XmlDoWarnPCBinariesForAACNotFoundParam));
            this.AddHandler(ProjectParameterNames.Conversion.ExcludeStringTable, typeof(XmlExcludeStringTableParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoOutputPCBinariesForAAC, typeof(XmlDoOutputPCBinariesForAACParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoUseHardwareOpusDecoder, typeof(XmlDoUseHardwareOpusDecoderParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoDeleteGarbageOutputBinaries, typeof(XmlDoDeleteGarbageOutputBinariesParam));
            this.AddHandler(ProjectParameterNames.Conversion.ExternalFileDirectoryPath, typeof(XmlExternalFileDirectoryPathParam));
            this.AddHandler(ProjectParameterNames.Conversion.UserManagementFileDirectoryPath, typeof(XmlUserManagementFileOutputDirectoryPathParam));
            this.AddHandler(ProjectParameterNames.Conversion.IntermediateOutputDirectoryPath, typeof(XmlIntermediateOutputDirectoryPathParam));
            this.AddHandler(ProjectParameterNames.Conversion.InGameEditCacheOutputDirectoryPath, typeof(XmlInGameEditCacheOutputDirectoryPathParam));
            this.AddHandler(ProjectParameterNames.Conversion.IsPostConvertCommandsEnabled, typeof(XmlIsPostConvertCommandsEnabledParam));
            this.AddHandler(ProjectParameterNames.Conversion.IsPreConvertCommandsEnabled, typeof(XmlIsPreConvertCommandsEnabledParam));
            this.AddHandler(ProjectParameterNames.Conversion.KeepIntermediateTextSequence, typeof(XmlKeepIntermediateTextSequenceParam));
            this.AddHandler(ProjectParameterNames.Conversion.OutputLabel, typeof(XmlOutputLabelParam));
            this.AddHandler(ProjectParameterNames.Conversion.OutputDirectoryPath, typeof(XmlOutputDirectoryPathParam));
            this.AddHandler(ProjectParameterNames.Conversion.SmfTimebase, typeof(XmlSmfTimebaseParam));
            this.AddHandler(ProjectParameterNames.Conversion.DoUseBuiltInWavePreprocessExe, typeof(XmlDoUseBuiltInWavePreprocessExeParam));
            this.AddHandler(ProjectParameterNames.Conversion.WavePreprocessExePath, typeof(XmlWavePreprocessExePathParam));

            // アイテムの命名設定
            this.AddHandler(ProjectParameterNames.ItemNaming.BankNamePrefix, typeof(XmlBankNamePrefixParam));
            this.AddHandler(
                ProjectParameterNames.ItemNaming.CaseChange, typeof(XmlCaseChangeParam),
                XmlCaseChangeTypeParam2Model, Model2XmlCaseChangeTypeParam);
            this.AddHandler(ProjectParameterNames.ItemNaming.GroupNamePrefix, typeof(XmlGroupNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.HasPrefix, typeof(XmlHasPrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.InstrumentNamePrefix, typeof(XmlInstrumentNamePrefixParam));
            this.AddHandler(
                ProjectParameterNames.ItemNaming.InvalidCharChange, typeof(XmlInvalidCharChangeParam),
                XmlInvalidCharChangeTypeParam2Model, Model2XmlInvalidCharChangeTypeParam);
            this.AddHandler(ProjectParameterNames.ItemNaming.PlayerNamePrefix, typeof(XmlPlayerNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.SequenceSoundNamePrefix, typeof(XmlSequenceSoundNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.SequenceSoundSetNamePrefix, typeof(XmlSequenceSoundSetNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.StreamSoundNamePrefix, typeof(XmlStreamSoundNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.WaveArchiveNamePrefix, typeof(XmlWaveArchiveNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.WaveSoundNamePrefix, typeof(XmlWaveSoundNamePrefixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.WaveSoundSetNamePrefix, typeof(XmlWaveSoundSetNamePrefixParam));

            this.AddHandler(ProjectParameterNames.ItemNaming.ItemPastePostfix, typeof(XmlItemPastePostfixParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.EnabledNameDelimiter, typeof(XmlEnabledNameDelimiterParam));
            this.AddHandler(ProjectParameterNames.ItemNaming.NameDelimiter, typeof(XmlNameDelimiterParam));

            // コメントカラム名の設定
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment, typeof(XmlCommentColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment1, typeof(XmlComment1ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment2, typeof(XmlComment2ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment3, typeof(XmlComment3ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment4, typeof(XmlComment4ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment5, typeof(XmlComment5ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment6, typeof(XmlComment6ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment7, typeof(XmlComment7ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment8, typeof(XmlComment8ColumnTextParam));
            this.AddHandler(ProjectParameterNames.CommentColumnText.Comment9, typeof(XmlComment9ColumnTextParam));

            // カラーコメントの設定
            this.AddHandler(ProjectParameterNames.ColorComment.Comment0, typeof(XmlColorComment0TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment1, typeof(XmlColorComment1TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment2, typeof(XmlColorComment2TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment3, typeof(XmlColorComment3TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment4, typeof(XmlColorComment4TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment5, typeof(XmlColorComment5TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment6, typeof(XmlColorComment6TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment7, typeof(XmlColorComment7TextParam));
            this.AddHandler(ProjectParameterNames.ColorComment.Comment8, typeof(XmlColorComment8TextParam));

            // プロジェクトコメントの設定
            this.AddHandler(ProjectParameterNames.Project.ProjectComment, typeof(XmlProjectCommentTextParam));

            // ファイルイベントの設定
            this.AddHandler(ProjectParameterNames.FileEvent.IsFileSavePreCommandEnabled, typeof(XmlIsFileSavePreCommandEnabledParam));
            this.AddHandler(ProjectParameterNames.FileEvent.IsFileSavePostCommandEnabled, typeof(XmlIsFileSavePostCommandEnabledParam));
            this.AddHandler(ProjectParameterNames.FileEvent.FileSavePreCommandPath, typeof(XmlFileSavePreCommandPathParam));
            this.AddHandler(ProjectParameterNames.FileEvent.FileSavePostCommandPath, typeof(XmlFileSavePostCommandPathParam));

            // sndedit設定
            this.AddHandler(ProjectParameterNames.SndEditSetting.SyncPort, typeof(XmlSyncPortParam));
            this.AddHandler(ProjectParameterNames.SndEditSetting.FuncPort, typeof(XmlFuncPortParam));
            this.AddHandler(ProjectParameterNames.SndEditSetting.CtrlPort, typeof(XmlCtrlPortParam));

            this.AddHandler(ProjectParameterNames.SndEditSetting.SyncChannel, typeof(XmlSyncChannelParam));
            this.AddHandler(ProjectParameterNames.SndEditSetting.FuncChannel, typeof(XmlFuncChannelParam));
            this.AddHandler(ProjectParameterNames.SndEditSetting.CtrlChannel, typeof(XmlCtrlChannelParam));

            // 接続、切断の設定
            this.AddHandler(ProjectParameterNames.Connection.ConnectionTimeOut, typeof(XmlTimeOutParam));

            // 統計の設定
            this.AddHandler(ProjectParameterNames.Statistics.EnabledIntegratedLoudnessThreshold, typeof(XmlEnabledIntegratedLoudnessThresholdParam));
            this.AddHandler(ProjectParameterNames.Statistics.IntegratedLoudnessThreshold, typeof(XmlIntegratedLoudnessThresholdParam));
            this.AddHandler(ProjectParameterNames.Statistics.SequenceMaxMeasureDuration, typeof(XmlSequenceMaxMeasureDurationParam));
        }

        //-----------------------------------------------------------------
        // CaseChangeType
        //-----------------------------------------------------------------

        private void XmlCaseChangeTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlCaseChangeParam src = paramXml as XmlCaseChangeParam;
            CaseChangeType value = CaseChangeTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlCaseChangeTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is CaseChangeTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlCaseChangeParam destValue = new XmlCaseChangeParam()
            {
                Value = (value as CaseChangeTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // InvalidCharChangeType
        //-----------------------------------------------------------------

        private void XmlInvalidCharChangeTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlInvalidCharChangeParam src = paramXml as XmlInvalidCharChangeParam;
            InvalidCharChangeType value = InvalidCharChangeTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlInvalidCharChangeTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is InvalidCharChangeTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlInvalidCharChangeParam destValue = new XmlInvalidCharChangeParam()
            {
                Value = (value as InvalidCharChangeTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }
    }
}
