﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System.IO;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.ToolDevelopmentKit;

    public class PathResolver
    {
        public string BasePath { get; set; }

        public string GetFullPath(string relativePath)
        {
            Assertion.Argument.NotNull(relativePath);

            return (this.BasePath != null && this.BasePath.Length > 0) ?
                Path.Combine(this.BasePath, relativePath).GetFullPath() : relativePath;
        }

        public string GetRelativePath(string path)
        {
            Assertion.Argument.NotNull(path);

            return (this.BasePath != null && this.BasePath.Length > 0) ?
                PathEx.MakeRelative(path, this.BasePath) : path;
        }
    }
}
