﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    internal class BankModel2XmlTranslator : Model2XmlTranslator
    {
        public BankModel2XmlTranslator()
            : base(new BankItemParamTranslator())
        {
            this.AddConverter<Bank, XmlBank>();
            this.AddConverter<Instrument, XmlInstrument>();
            this.AddConverter<KeyRegion, XmlKeyRegion>();
            this.AddConverter<VelocityRegion, XmlVelocityRegion>();
        }

        public XmlBank Run(Bank bank)
        {
            return this.Run<XmlBank>(bank) as XmlBank;
        }
    }
}
