﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using YamlDotNet.Serialization;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdk
{
    /// <summary>
    /// アイテムフィルタ設定を格納します。
    /// </summary>
    public class ItemFilterSettings
    {
        /// <summary>
        /// アイテムフィルタ設定のリストを取得または設定します。
        /// </summary>
        [YamlMember(Alias = "filters")]
        public List<ItemFilter> Filters { get; set; }
    }

    /// <summary>
    /// １件のアイテムフィルタ情報を格納します。
    /// </summary>
    public class ItemFilter
    {
        /// <summary>
        /// フィルタ対象の名前を取得または設定します。
        /// </summary>
        /// <remarks>
        /// 現在の運用では、
        /// すべてのサウンドアーカイブを対象とする場合は null か空文字を、
        /// バンク内のインストを対象とする場合はバンクのファイルパスを指定します。
        /// バンクファイルパスを指定する際には、環境変数やサウンドプロジェクトからの相対パスを利用することができます。
        /// </remarks>
        [YamlMember(Alias = "target")]
        public string Target { get; set; }

        /// <summary>
        /// 名前フィルタのための正規表現パターンリストを取得または設定します。
        /// </summary>
        [YamlMember(Alias = "patterns")]
        public List<string> Patterns { get; set; }
    }
}
