﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Documents
{
    /// <summary>
    /// ドキュメントの生成をサポートします。
    /// </summary>
    public interface IDocumentFactory
    {
        /// <summary>
        /// 生成するドキュメントの種類を取得します。
        /// </summary>
        string TypeName { get; }

        /// <summary>
        /// ドキュメントを生成します。
        /// </summary>
        /// <returns>生成されたドキュメント。</returns>
        Document CreateDocument();
    }
}
