﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Documents
{
    /// <summary>
    /// DocumentReference イベントを処理するメソッドを表します。
    /// </summary>
    /// <param name="sender">イベントのソース。</param>
    /// <param name="e">DocumentReference イベントデータ。</param>
    public delegate void DocumentReferenceEventHandler(object sender, DocumentReferenceEventArgs e);

    /// <summary>
    /// DocumentReference イベントデータを格納します。
    /// </summary>
    public class DocumentReferenceEventArgs : EventArgs
    {
        private DocumentReference _documentReference;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="component">DocumentReference。</param>
        public DocumentReferenceEventArgs(DocumentReference reference)
        {
            _documentReference = reference;
        }

        /// <summary>
        /// DocumentReference を取得します。
        /// </summary>
        public DocumentReference DocumentReference
        {
            get { return _documentReference; }
        }
    }
}
