﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Core
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using MessageResource = NintendoWare.SoundFoundation.Resources.MessageResource;

    public class FileNotSupportedVersionException : Exception
    {
        private string version = string.Empty;
        private string filePath = string.Empty;

        public FileNotSupportedVersionException()
            : this(string.Empty, string.Empty)
        {
        }

        public FileNotSupportedVersionException(string version)
            : this(string.Empty, version)
        {
        }

        public FileNotSupportedVersionException(string filePath, string version)
            : this(MessageResource.Message_UnsupportedFileVersion, filePath, version)
        {
        }

        public FileNotSupportedVersionException(string message, string filePath, string version)
            : base(message)
        {
            if (null == filePath)
            {
                throw new ArgumentNullException("filePath");
            }

            if (null == version)
            {
                throw new ArgumentNullException("version");
            }

            this.filePath = filePath;
            this.version = version;
        }

        /// <summary>
        /// 対象ファイルパスを取得します。
        /// </summary>
        public string FilePath
        {
            get { return this.filePath; }
            set { this.filePath = value; }
        }

        /// <summary>
        /// バージョンを取得します。
        /// </summary>
        public string Version
        {
            get { return this.version; }
        }
    }
}
