﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// テキストを関連付けます。
    /// </summary>
    public class TextAttribute : Attribute
    {
        private string _text = string.Empty;    // テキスト

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextAttribute() { }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="text">関連付けるテキスト。</param>
        public TextAttribute(string text)
        {
            Text = text;
        }

        /// <summary>
        /// テキストを取得または設定します。
        /// </summary>
        public string Text
        {
            get { return _text; }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }
                _text = value;
            }
        }
    }
}
