﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Threading;

namespace NintendoWare.SoundFoundation.Core.Threading
{
    /// <summary>
    /// Thread の拡張機能を提供します。
    /// </summary>
    public static class ThreadEx
    {
        /// <summary>
        /// スレッドの CurrentUICulture を初期化します。
        /// </summary>
        /// <param name="thread">対象スレッド。</param>
        public static void InitializeCurrentUICulture(this Thread thread)
        {
            string satelliteAssemblyLocation =
                Path.Combine(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location), "en");
            var oneOfSatelliteAssemblies = Path.Combine(satelliteAssemblyLocation, "SoundFoundation.resources.dll");

            if (!File.Exists(oneOfSatelliteAssemblies))
            {
                thread.CurrentCulture = new CultureInfo("ja-JP");
                thread.CurrentUICulture = new CultureInfo("ja-JP");
            }
            else
            {
                thread.CurrentCulture = new CultureInfo("en-US");
                thread.CurrentUICulture = new CultureInfo("en-US");
            }
        }
    }
}
