﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Core.Threading
{
    using System;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 直接ハンドラを実行する Invoker です。
    /// </summary>
    public class DirectInvoker : IInvoker
    {
        /// <summary>
        /// 指定されたハンドラを非同期で実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        /// <returns>結果にアクセスするための IAsyncResult を返します。</returns>
        public IAsyncResult BeginInvoke(Action handler)
        {
            Ensure.Argument.NotNull(handler);
            handler();
            return null;
        }

        /// <summary>
        /// 指定されたハンドラを実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        public void Invoke(Action handler)
        {
            Ensure.Argument.NotNull(handler);
            handler();
        }
    }
}
