﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Reflection;

namespace NintendoWare.SoundFoundation.Core.Reflection
{
    public static class ObjectFinder
    {
        public static IEnumerable<TType> FindStaticValues<TType>(Type type, BindingFlags targetFlags)
        {
            if (null == type) { throw new ArgumentNullException("type"); }

            BindingFlags bindingFlags = BindingFlags.Public | BindingFlags.Static | targetFlags;

            foreach (PropertyInfo property in type.GetProperties(bindingFlags))
            {
                if (property.PropertyType != typeof(TType)) { continue; }
                yield return (TType)property.GetValue(null, null);
            }

            foreach (FieldInfo field in type.GetFields(bindingFlags))
            {
                if (field.FieldType != typeof(TType)) { continue; }
                yield return (TType)field.GetValue(null);
            }
        }
    }
}
