﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Core.Parameters
{
    /// <summary>
    /// パラメータ属性です。
    /// </summary>
    public static class ParameterAttributes
    {
        /// <summary>
        /// ハッシュ計算対象であることを示します。
        /// </summary>
        /// <remarks>
        /// この属性が設定されたパラメータは、
        /// その値が変更されると再コンバートの対象になります。
        /// </remarks>
        public const string ComputeHash = "ComputeHash";

        /// <summary>
        /// オプションのハッシュ計算対象であることを示します。
        /// </summary>
        /// <remarks>
        /// この属性が設定されたパラメータは、
        /// その値が変更されると再コンバートの対象になる可能性があります。
        /// </remarks>
        public const string OptionalHashTarget = "OptionalHashTarget";

        /// <summary>
        /// SoundArchive ハッシュ計算対象であることを示します。
        /// </summary>
        /// <remarks>
        /// この属性が設定されたパラメータは、
        /// その値が変更されると SoundArchive の再コンバートの対象になります。
        /// </remarks>
        public const string ComputeSoundArchiveHash = "ComputeSoundArchiveHash";

        /// <summary>
        /// sndedit 再転送 ハッシュ計算対象であることを示します。
        /// </summary>
        /// <remarks>
        /// この属性が設定されたパラメータは、
        /// その値が変更されると sndedit の再転送の対象になります。
        /// </remarks>
        public const string ComputeSndeditTransferHash = "ComputeSndeditTransferHash";
    }
}
