﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System;
    using ToolDevelopmentKit;

    /// <summary>
    /// 値の範囲を格納します。
    /// </summary>
    public class ValueRangeAttribute : Attribute
    {
        private object min = null;
        private object max = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="min">最小値を指定します。</param>
        /// <param name="max">最大値を指定します。</param>
        public ValueRangeAttribute(int min, int max)
        {
            Ensure.Argument.True(min <= max);
            this.min = min;
            this.max = max;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="min">最小値を指定します。</param>
        /// <param name="max">最大値を指定します。</param>
        public ValueRangeAttribute(float min, float max)
        {
            Ensure.Argument.True(min <= max);
            this.min = min;
            this.max = max;
        }

        public object Mininum
        {
            get { return this.min; }
        }

        public object Maximum
        {
            get { return this.max; }
        }
    }
}
