﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// オブジェクト型のパラメータ値を表します。
    /// </summary>
    public sealed class ObjectParameterValue<TValue> : ParameterValue<TValue>
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ObjectParameterValue()
            : base(default(TValue))
        {
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="value">パラメータ値。</param>
        public ObjectParameterValue(TValue value)
            : base(value)
        {
        }

        /// <summary>
        /// テキストからパラメータ値を取得します。
        /// </summary>
        /// <param name="text">テキストを指定します。</param>
        protected override TValue ParseInternal(string text)
        {
            // 実装しません。
            throw new NotImplementedException();
        }

        /// <summary>
        /// 指定した値を検証します。
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        protected override ValidationResult ValidateInternal(TValue value)
        {
            return ValidationResult.NoError;
        }

        /// <summary>
        /// パラメータ値のバイト列を取得します。
        /// </summary>
        /// <returns>バイト列の列挙子を返します。</returns>
        protected sealed override IEnumerable<byte> GetBytes()
        {
            return new byte[0];
        }
    }
}
