﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System.Collections.Generic;
    using System.Collections.Specialized;

    /// <summary>
    /// パラメータの値を格納します。
    /// </summary>
    public abstract class CollectionParameterValue<TValueCollection, TValue> : ParameterValue<TValueCollection>
        where TValueCollection : IEnumerable<TValue>, INotifyCollectionChanged
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public CollectionParameterValue() { }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public CollectionParameterValue(TValueCollection value)
        {
            this.Value = value;
        }

        /// <summary>
        /// 指定した値を検証します。
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        protected override ValidationResult ValidateInternal(TValueCollection value)
        {
            return ValidationResult.NoError;
        }
    }
}
