﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Midi
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Core.Collections;
    using NintendoWare.ToolDevelopmentKit.Collections;

    public static class MidiDeviceManager
    {
        public static IKeyedList<string, MidiInputDevice> InputDevices
        {
            get
            {
                IKeyedList<string, MidiInputDevice> devices = new MidiInputDeviceList();

                for (uint nDevice = 0; nDevice < Win32.Winmm.MidiInGetNumDevs(); nDevice++)
                {
                    Win32.MIDIINCAPS caps = new Win32.MIDIINCAPS();
                    Win32.Winmm.MidiInGetDevCaps(nDevice, out caps, (uint)Marshal.SizeOf(caps));

                    devices.Add(new MidiInputDevice((int)nDevice, caps.strPname));
                }

                return devices;
            }
        }

        private class MidiInputDeviceList : KeyedListDecorator<string, MidiInputDevice>
        {
            public MidiInputDeviceList()
                : base(new ObservableList<MidiInputDevice>(), GetMidiInputDeviceName)
            {
            }

            private static string GetMidiInputDeviceName(MidiInputDevice item)
            {
                return item.Name;
            }
        }
    }
}
