﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.IO
{
    using System;
    using System.IO;
    using System.Text;

    public static class BigEndianBinaryReader
    {
        public static BinaryReader Create(Stream stream)
        {
            if (BitConverter.IsLittleEndian)
            {
                return new ReverseEndianBinaryReader(stream);
            }

            return new BinaryReader(stream);
        }

        public static BinaryReader Create(Stream stream, Encoding encoding)
        {
            if (BitConverter.IsLittleEndian)
            {
                return new ReverseEndianBinaryReader(stream, encoding);
            }

            return new BinaryReader(stream, encoding);
        }
    }
}
