﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// サウンドプロジェクトコンバートイベントのデータを格納します。
    /// </summary>
    public class SoundProjectConvertEventArgs : EventArgs
    {
        private readonly SoundProjectService projectService;
        private readonly bool succeeded = true;
        private readonly bool canceled = false;
        private readonly bool isPartsConvert = false;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="projectService">コンバート対象のプロジェクトサービス。</param>
        /// <param name="succeeded">コンバートの結果。成功なら true、失敗なら false。</param>
        /// <param name="canceled">キャンセルされた場合は true。</param>
        /// <param name="isPartsConvert">部分コンバートの場合は false。</param>
        public SoundProjectConvertEventArgs(
            SoundProjectService projectService,
            bool succeeded,
            bool canceled,
            bool isPartsConvert)
        {
            Ensure.Argument.NotNull(projectService);

            this.projectService = projectService;
            this.succeeded = succeeded;
            this.canceled = canceled;
            this.isPartsConvert = isPartsConvert;
        }

        /// <summary>
        /// コンバート対象のプロジェクトサービスを取得します。
        /// </summary>
        public SoundProjectService ProjectService
        {
            get { return this.projectService; }
        }

        /// <summary>
        /// コンバートの結果を取得します。
        /// </summary>
        public bool Succeeded
        {
            get { return this.succeeded; }
        }

        /// <summary>
        /// コンバートがキャンセルされたかどうかを取得します。
        /// </summary>
        public bool Canceled
        {
            get { return this.canceled; }
        }

        /// <summary>
        /// 部分コンバートかどうかを取得します。
        /// </summary>
        public bool IsPartsConvert
        {
            get { return this.isPartsConvert; }
        }
    }
}
