﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Text;
    using NintendoWare.SoundFoundation.Logs;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// コンバートの例外クラスです。
    /// </summary>
    public class ConversionException : Exception
    {
        private OutputLine[] lines = new OutputLine[0];
        private string message = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="line">ラインを指定します。</param>
        public ConversionException(OutputLine line)
            : this(new OutputLine[] { line })
        {
            Ensure.Argument.NotNull(line);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="lines">ラインの配列を指定します。</param>
        public ConversionException(OutputLine[] lines)
        {
            Ensure.Argument.NotNull(lines);
            this.lines = lines;
        }

        /// <summary>
        /// ラインの配列を取得します。
        /// </summary>
        public OutputLine[] Lines
        {
            get { return this.lines; }
        }

        /// <summary>
        /// 現在の例外を説明するメッセージを取得します。
        /// </summary>
        public override string Message
        {
            get
            {
                if (this.message == null)
                {
                    StringBuilder builder = new StringBuilder();

                    foreach (OutputLine line in this.lines)
                    {
                        builder.AppendLine(line.Text);
                    }

                    this.message = builder.ToString();
                }

                return this.message;
            }
        }
    }
}
