﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    /// <summary>
    /// 他の出力に依存した出力を操作します。
    /// </summary>
    public interface IDependentOutput
    {
        /// <summary>
        /// DependencyManagerを取得します。
        /// </summary>
        DependencyManager Owner { get; }

        /// <summary>
        /// 参照カウントを取得します。
        /// </summary>
        int ReferenceCount { get; }

        /// <summary>
        /// キーを取得します。
        /// </summary>
        string Key { get; }

        /// <summary>
        /// 出力情報コレクションを取得します。
        /// </summary>
        IDependentOutputItemCollection OutputItems { get; }

        /// <summary>
        /// 依存情報コレクションを取得します。
        /// </summary>
        IDependedFileInfoCollection Dependencies { get; }

        /// <summary>
        /// 出力ファイルの有効性を確認します。
        /// </summary>
        bool Dirty { get; }

        /// <summary>
        /// 強制的に無効にする設定を行います。
        /// </summary>
        bool ForceDirty { set; }

        /// <summary>
        /// 依存ファイルが存在しているかを確認します。
        /// </summary>
        bool DependencyFilesExists { get; }

        /// <summary>
        /// 出力ファイルを削除します。
        /// </summary>
        void Clean();

        /// <summary>
        /// 依存ファイルが存在しているかを確認します。
        /// </summary>
        void ValidateDependencies();
    }
}
