﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Xml;
    using NintendoWare.SoundFoundation.Core;

    /// <summary>
    /// 依存ファイル情報インターフェイス
    /// </summary>
    public interface IDependedFileInfo
    {
        /// <summary>
        /// DependencyManagerを取得します。
        /// </summary>
        DependencyManager Owner { get; set; }

        /// <summary>
        /// キーを取得します。
        /// </summary>
        string Key { get; }

        /// <summary>
        /// ファイルパスを取得します。
        /// </summary>
        string FilePath { get; }

        /// <summary>
        /// フルパスを取得します。
        /// </summary>
        string AbsoluteFilePath { get; }

        /// <summary>
        /// 最終更新時間を取得します。
        /// </summary>
        DateTime LastUpdatedTime { get; }

        /// <summary>
        /// 最終更新時のハッシュコードを取得または設定します。
        /// </summary>
        HashCode LastUpdatedHashCode { get; set; }

        /// <summary>
        /// 現在のハッシュコードを取得または設定します。
        /// </summary>
        HashCode CurrentHashCode { get; set; }

        /// <summary>
        /// 依存ファイル情報をXML出力します。
        /// </summary>
        /// <param name="document">XMLドキュメント</param>
        /// <returns>XML要素</returns>
        XmlElement ToXml(XmlDocument document);
    }
}
