﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System.IO;

    /// <summary>
    /// 出力対象アイテムを管理するインターフェイスです。
    /// </summary>
    public interface IOutputItem
    {
        /// <summary>
        /// 出力が Dirty かどうかを調べます。
        /// </summary>
        bool IsDirty { get; }

        /// <summary>
        /// 出力パスを取得します。
        /// </summary>
        string Path { get; }

        /// <summary>
        /// 読み込み用のストリームを開きます。
        /// </summary>
        /// <returns>入力ストリームを返します。</returns>
        Stream OpenRead();

        /// <summary>
        /// 書き込み用のストリームを開きます。
        /// </summary>
        /// <returns>出力ストリームを返します。</returns>
        Stream OpenWrite();

        /// <summary>
        /// クリーンします。
        /// </summary>
        void Clean();
    }
}
