﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Logs;
    using ToolDevelopmentKit;

    /// <summary>
    /// コンソールベースのコンバート機能を提供する基本クラスです。
    /// </summary>
    public interface IConsoleBasedConverter<TContext>
        where TContext : ConversionContext
    {
        string LogPrefix { get; set; }

        bool Run(TContext context);
    }
}
