﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System.Collections.Generic;

    /// <summary>
    /// コンバート特性を格納します。
    /// </summary>
    public class ConversionTraits
    {
        public const int MaxSampleRate = 192000;
        public const int MinSampleRate = 2000;

        private const int maxPath = 256;

        private bool isLittleEndian = false;
        private int maxFileName = maxPath;

        public ConversionTraits(bool isLittleEndian)
        {
            this.isLittleEndian = isLittleEndian;
        }

        public ConversionTraits(bool isLittleEndian, int maxFileName)
        {
            this.isLittleEndian = isLittleEndian;
            this.maxFileName = maxFileName;
        }

        public static int MaxPath
        {
            get { return maxPath; }
        }

        public bool IsLittleEndian
        {
            get { return this.isLittleEndian; }
        }

        public int MaxFileName
        {
            get { return this.maxFileName; }
            set { this.maxFileName = value; }
        }
    }
}
