﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// コンポーネントに関連するファイルを表すクラスです。
    /// </summary>
    internal class ComponentFile : Component
    {
        /// <summary>
        /// 対象コンポーネントを取得または設定します。
        /// </summary>
        public Component TargetComponent
        {
            get { return GetValue<Component>(ConversionParameterNames.TargetComponent); }
            set { SetValue<Component>(ConversionParameterNames.TargetComponent, value); }
        }

        /// <summary>
        /// 外部ファイルパスを取得または設定します。
        /// </summary>
        public string ExternalFilePath
        {
            get { return GetValue<string>(ConversionParameterNames.ExternalFilePath); }
            set { SetValue<string>(ConversionParameterNames.ExternalFilePath, value); }
        }

        /// <summary>
        /// ファイルの格納形式を取得または設定します。
        /// </summary>
        public FileStoring Storing
        {
            get { return GetValue<FileStoring>(ConversionParameterNames.FileStoring); }
            set { SetValue<FileStoring>(ConversionParameterNames.FileStoring, value); }
        }

        /// <summary>
        /// 外部ファイルかどうかを取得します。
        /// </summary>
        public bool IsExternal
        {
            get
            {
                return (this.ExternalFilePath.Length > 0) &&
                    (this.Storing == FileStoring.Referenced );
            }
        }

        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            this.Parameters.AddValue(
                ConversionParameterNames.TargetComponent, new ObjectParameterValue<Component>());
            this.Parameters.AddValue(
                ConversionParameterNames.ExternalFilePath, new FilePathParameterValue());
            this.Parameters.AddValue(
                ConversionParameterNames.FileStoring, new FileStoringParameterValue());
        }
    }
}
