﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using System.Linq;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Resources;

    internal class SoundSetSoundListInfoProvider : ListInfoProvider<Sound>
    {
        private SoundSet soundSet;
        private bool isIgnoreDisableItems;
        private SoundProjectReportTraits traits;
        private UserParameterStructureSettings userParameterStructureSettings;

        public SoundSetSoundListInfoProvider(
            UserParameterStructureSettings userParameterStructureSettings,
            SoundProjectReportTraits traits,
            SoundSet soundSet,
            bool isIgnoreDisableItems,
            ListOutput listOutput)
            : base(traits, listOutput)
        {
            this.userParameterStructureSettings = userParameterStructureSettings;
            this.soundSet = soundSet;
            this.isIgnoreDisableItems = isIgnoreDisableItems;
            this.traits = traits;
        }

        public override string Caption
        {
            get { return "Sound List"; }
        }

        public override IEnumerable<Sound> Items
        {
            get { return this.soundSet.EnumerateItems(this.isIgnoreDisableItems).OfType<Sound>(); }
        }

        public override IEnumerable<Column> Columns
        {
            get
            {
                if (!this.ListOutput.IsOutput)
                {
                    yield break;
                }

                foreach (ListColumnOutput columnOutput in this.ListOutput.ColumnOutputs)
                {
                    if (!columnOutput.IsOutput)
                    {
                        continue;
                    }

                    List<UserParameterStructure> structures = new List<UserParameterStructure>();
                    string label = string.Empty;
                    switch (columnOutput.Name)
                    {
                        case SoundProjectReportTraits.ColumnName.UserParameter:
                            label = "UserParam";
                            structures = this.userParameterStructureSettings.Settings[0].Structures;
                            break;

                        case SoundProjectReportTraits.ColumnName.UserParameter1:
                            label = "UserParam1";
                            structures = this.userParameterStructureSettings.Settings[1].Structures;
                            break;

                        case SoundProjectReportTraits.ColumnName.UserParameter2:
                            label = "UserParam2";
                            structures = this.userParameterStructureSettings.Settings[2].Structures;
                            break;

                        case SoundProjectReportTraits.ColumnName.UserParameter3:
                            label = "UserParam3";
                            structures = this.userParameterStructureSettings.Settings[3].Structures;
                            break;
                    }

                    if (0 < structures.Count)
                    {
                        foreach (UserParameterStructure structure in structures)
                        {
                            yield return
                                new Column(columnOutput.Name + "_" + structure.Label,
                                           ColumnText(label, structure.Label),
                                           StructureType2ColumnSortType(structure.StructureType),
                                           true);
                        }
                    }
                    else
                    {
                        yield return this.traits.Columns[columnOutput.Name];
                    }
                }
            }
        }

        private string ColumnText(string org, string cus)
        {
            if (org == cus)
            {
                return org;
            }
            else
            {
                return cus + "<br>(" + org + ")";
            }
        }

        private ColumnSortType StructureType2ColumnSortType(StructureTypes type)
        {
            switch (type)
            {
                case StructureTypes.Integer:
                case StructureTypes.UInteger:
                case StructureTypes.Decimal:
                    return ColumnSortType.Number;

                case StructureTypes.Boolean:
                    return ColumnSortType.String;
            }

            return ColumnSortType.String;
        }
    }
}
