﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using Projects;

    internal class ProjectItemListInfoProvider<ItemType> : ListInfoProvider<ItemType>
        where ItemType : SoundSetItem
    {
        private readonly string caption;
        private readonly IEnumerable<ItemType> items;

        public ProjectItemListInfoProvider(
            SoundProjectReportTraits traits,
            IEnumerable<ItemType> items,
            string caption,
            ListOutput listOutput)
            : base(traits, listOutput)
        {
            this.caption = caption;
            this.items = items;
        }

        public override string Caption
        {
            get { return this.caption; }
        }

        public override IEnumerable<ItemType> Items
        {
            get { return this.items; }
        }
    }
}
