﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using Projects;
    using ToolDevelopmentKit;

    internal class GroupInfoProvider : IListItemInfoProvider<GroupBase>
    {
        public delegate string GetTextHandler(Column column, int itemIndex, GroupBase item);

        private static IDictionary<string, GetTextHandler> getTextHandlers = new Dictionary<string, GetTextHandler>();

        static GroupInfoProvider()
        {
            InitializeGetTextHandlers();
        }

        /// <summary>
        /// 指定したアイテムが有効かどうかを調べます。
        /// </summary>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>アイテムが有効なら true、無効なら false を返します。</returns>
        public bool IsEnabled(GroupBase item)
        {
            Assertion.Argument.NotNull(item);
            return item.IsHierarchyEnabled;
        }

        /// <summary>
        /// 指定したアイテムのカラーインデックスを取得します。
        /// </summary>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>アイテムのカラーインデックスを返します。</returns>
        public int GetColorIndex(GroupBase item)
        {
            Assertion.Argument.NotNull(item);
            return item.ColorIndex;
        }

        /// <summary>
        /// 指定したカラムとアイテムに対応するテキストを取得します。
        /// </summary>
        /// <param name="column">対象カラムを指定します。</param>
        /// <param name="itemIndex">対象アイテムのインデックスを指定します。</param>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>取得したテキストを返します。</returns>
        public string GetText(Column column, int itemIndex, GroupBase item)
        {
            Assertion.Argument.NotNull(column);
            Assertion.Argument.NotNull(item);
            return getTextHandlers[column.Name](column, itemIndex, item);
        }

        private static void InitializeGetTextHandlers()
        {
            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment,
                (Column column, int itemIndex, GroupBase item) => item.Comment);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.ItemIndex,
                (Column column, int itemIndex, GroupBase item) => (itemIndex < 0) ? "-" : itemIndex.ToString());

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Name,
                (Column column, int itemIndex, GroupBase item) => item.Name);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment1,
                (Column column, int itemIndex, GroupBase item) => item.Comment1);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment2,
                (Column column, int itemIndex, GroupBase item) => item.Comment2);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment3,
                (Column column, int itemIndex, GroupBase item) => item.Comment3);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment4,
                (Column column, int itemIndex, GroupBase item) => item.Comment4);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment5,
                (Column column, int itemIndex, GroupBase item) => item.Comment5);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment6,
                (Column column, int itemIndex, GroupBase item) => item.Comment6);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment7,
                (Column column, int itemIndex, GroupBase item) => item.Comment7);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment8,
                (Column column, int itemIndex, GroupBase item) => item.Comment8);

            getTextHandlers.Add(
                SoundProjectReportTraits.ColumnName.Comment9,
                (Column column, int itemIndex, GroupBase item) => item.Comment9);
        }
    }
}
