﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// リストアイテムの情報を格納します。
    /// </summary>
    /// <typeparam name="TComponent"></typeparam>
    internal class ListItem<TComponent>
        where TComponent : Component
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="index">リストアイテムのインデックスを指定します。</param>
        /// <param name="component">関連するコンポーネントを指定します。</param>
        public ListItem(int index, TComponent component)
        {
            Ensure.Argument.True(index >= 0);
            Ensure.Argument.NotNull(component);

            this.Index = index;
            this.Component = component;
        }

        /// <summary>
        /// リストアイテムのインデックスを取得します。
        /// </summary>
        public int Index { get; private set; }

        /// <summary>
        /// 関連するコンポーネントを取得します。
        /// </summary>
        public TComponent Component { get; private set; }
    }
}
