﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Text;
    using System.Xml;
    using Projects;
    using ToolDevelopmentKit;

    internal abstract class ListInfoProvider<TItem> : IListInfoProvider<TItem>
    {
        private ReportTraits traits;

        public ListInfoProvider(ReportTraits traits, ListOutput listOutput)
        {
            Assertion.Argument.NotNull(traits);
            Assertion.Argument.NotNull(listOutput);
            this.traits = traits;
            this.ListOutput = listOutput;
        }

        public ListOutput ListOutput { get; private set; }

        public abstract string Caption { get; }

        public virtual IEnumerable<Column> Columns
        {
            get
            {
                if (!this.ListOutput.IsOutput)
                {
                    yield break;
                }

                foreach (ListColumnOutput columnOutput in this.ListOutput.ColumnOutputs)
                {
                    if (!columnOutput.IsOutput)
                    {
                        continue;
                    }

                    yield return this.traits.Columns[columnOutput.Name];
                }
            }
        }

        public abstract IEnumerable<TItem> Items { get; }
    }
}
