﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    internal interface IListItemInfoProvider<TItem>
    {
        /// <summary>
        /// 指定したアイテムが有効かどうかを調べます。
        /// </summary>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>アイテムが有効なら true、無効なら false を返します。</returns>
        bool IsEnabled(TItem item);

        /// <summary>
        /// 指定したアイテムのカラーインデックスを取得します。
        /// </summary>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>アイテムのカラーインデックスを返します。</returns>
        int GetColorIndex(TItem item);

        /// <summary>
        /// 指定したカラムとアイテムに対応するテキストを取得します。
        /// </summary>
        /// <param name="column">対象カラムを指定します。</param>
        /// <param name="itemIndex">対象アイテムのインデックスを指定します。</param>
        /// <param name="item">対象アイテムを指定します。</param>
        /// <returns>取得したテキストを返します。</returns>
        string GetText(Column column, int itemIndex, TItem item);
    }
}
