﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// レポートのカラム情報を格納します。
    /// </summary>
    public class Column
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">カラムの名前を指定します。</param>
        /// <param name="text">カラムの表示テキストを指定します。</param>
        /// <param name="sortType">カラムのソートタイプを指定します。</param>
        public Column(string name, string text, ColumnSortType sortType)
            : this(name, text, sortType, false)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">カラムの名前を指定します。</param>
        /// <param name="text">カラムの表示テキストを指定します。</param>
        /// <param name="sortType">カラムのソートタイプを指定します。</param>
        /// <param name="isRaw">表示テキストにタグが含まれる場合指定します。</param>
        public Column(string name, string text, ColumnSortType sortType, bool isRaw)
        {
            Ensure.Argument.NotNull(name);
            Ensure.Argument.NotNull(text);

            this.Name = name;
            this.Text = text;
            this.SortType = sortType;
            this.IsRaw = isRaw;
        }

        /// <summary>
        /// カラムの名前を取得します。
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// カラムの表示テキストを取得します。
        /// </summary>
        public string Text { get; private set; }

        /// <summary>
        /// カラムのソートタイプを取得します。
        /// </summary>
        public ColumnSortType SortType { get; private set; }

        /// <summary>
        /// カラムの表示テキストを取得します。
        /// </summary>
        public bool IsRaw { get; private set; }
    }
}
