﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using Projects;

    internal class InstrumentListInfoProvider : ListInfoProvider<Instrument>
    {
        private BankService bankService;

        public InstrumentListInfoProvider(BankReportTraits traits, BankService bankService, ListOutput listOutput)
            : base(traits, listOutput)
        {
            this.bankService = bankService;
        }

        public override string Caption
        {
            get { return "Instrument List"; }
        }

        public override IEnumerable<Instrument> Items
        {
            get { return this.bankService.Instruments; }
        }
    }
}
