﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    /// <summary>
    /// バンクコンバート特性を格納します。
    /// </summary>
    public class BankConversionTraits : ComponentConversionTraits
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        public BankConversionTraits(bool isLittleEndian)
            : base(isLittleEndian)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        /// <param name="maxFilePath">ファイルパスの最大長を指定します。</param>
        public BankConversionTraits(bool isLittleEndian, int maxFilePath)
            : base(isLittleEndian, maxFilePath)
        {
        }
    }
}
