﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// １回のキーストローク情報を保持します。
    /// </summary>
    public struct KeyStroke
    {
        public static readonly KeyStroke NullKeyStroke = new KeyStroke(0, 0);     // Null キーストローク

        private int _key;           // キーコード
        private int _modifiers;     // 修飾キーコード

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="key">キーコード。</param>
        /// <param name="modifiers">修飾キーコード。</param>
        public KeyStroke(int key, int modifiers)
        {
            _key = key;
            _modifiers = modifiers;
        }

        /// <summary>
        /// キーコードを取得または設定します。
        /// </summary>
        public int Key
        {
            get { return _key; }
            set { _key = value; }
        }

        /// <summary>
        /// 修飾キーコードを取得または設定します。
        /// </summary>
        public int Modifiers
        {
            get { return _modifiers; }
            set { _modifiers = value; }
        }

        /// <summary>
        /// オペレータ ==。
        /// </summary>
        /// <param name="target1">キーストローク。</param>
        /// <param name="target2">キーストローク。</param>
        /// <returns>等しい場合は true、等しくない場合は false。</returns>
        public static bool operator ==(KeyStroke target1, KeyStroke target2)
        {
            return (target1.Key == target2.Key && target1.Modifiers == target2.Modifiers);
        }

        /// <summary>
        /// オペレータ !=。
        /// </summary>
        /// <param name="target1">キーストローク。</param>
        /// <param name="target2">キーストローク。</param>
        /// <returns>等しくない場合は true、等しい場合は false。</returns>
        public static bool operator !=(KeyStroke target1, KeyStroke target2)
        {
            return !(target1 == target2);
        }

        /// <summary>
        /// 指定オブジェクトと等しいかどうか調べます。
        /// </summary>
        /// <param name="obj">オブジェクト。</param>
        /// <returns>等しい場合は true、等しくない場合は false。</returns>
        public override bool Equals(object obj)
        {
            if (!(obj is KeyStroke)) { return false; }
            return (this == (KeyStroke)obj);
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値。</returns>
        public override int GetHashCode()
        {
            return _key.GetHashCode() ^ _modifiers.GetHashCode();
        }
    }
}
