﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// コマンドイベントを処理するメソッドを表します。
    /// </summary>
    /// <param name="sender">イベントのソース。</param>
    /// <param name="e">コマンドイベントデータ。</param>
    public delegate void CommandEventHandler(object sender, CommandEventArgs e);

    /// <summary>
    /// コマンドイベントデータを格納します。
    /// </summary>
    public class CommandEventArgs : EventArgs
    {
        private Command _command;
        private bool _executed = false;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="component">コマンド。</param>
        /// <param name="executed">コマンドを実行した場合は true、実行しなかった or キャンセルした場合は false。</param>
        public CommandEventArgs(Command command, bool executed)
        {
            _command = command;
            _executed = executed;
        }

        /// <summary>
        /// コマンドを取得します。
        /// </summary>
        public Command Command
        {
            get { return _command; }
        }

        public bool IsExecuted
        {
            get { return _executed; }
        }
    }
}
