﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Codecs
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential)]
    public struct WaveFormat
    {
        public WaveFormat(WaveFormat waveFormat)
        {
            this = waveFormat;
        }

        public string Encoding { get; set; }

        public int SamplingRate { get; set; }

        public int ChannelCount { get; set; }

        public int BitsPerSample { get; set; }

        public bool IsLittleEndian { get; set; }

        public bool IsSigned { get; set; }

        /// <summary>
        /// 補正前のループ開始位置を取得または設定します。
        /// </summary>
        public int OriginalLoopStartFrame { get; set; }

        /// <summary>
        /// 補正前のループ終了位置を取得または設定します。
        /// </summary>
        public int OriginalLoopEndFrame { get; set; }

        /// <summary>
        /// ループ開始位置を取得または設定します。
        /// </summary>
        public int LoopStartFrame { get; set; }

        /// <summary>
        /// ループ終了位置を取得または設定します。
        /// </summary>
        public int LoopEndFrame { get; set; }

        public bool HasLoop { get; set; }

        public IEnumerable<WaveRegionInfo> Regions { get; set; }

        public int SampleLength
        {
            get { return this.BitsPerSample / 8; }
        }

        public int FrameLength
        {
            get { return this.SampleLength * this.ChannelCount; }
        }
    }

    public class WaveMarkerInfo
    {
        private string name = string.Empty;

        //-----------------------------------------------------------------

        public WaveMarkerInfo(string name, uint position)
        {
            this.name = name ?? string.Empty;
            this.Position = position;
        }

        //-----------------------------------------------------------------

        public string Name
        {
            get { return this.name; }
        }

        public uint Position { get; private set; }
    }

    public class WaveRegionInfo
    {
        private string name = string.Empty;

        //-----------------------------------------------------------------

        public WaveRegionInfo(string name, uint startFrame, uint endFrame)
        {
            this.name = name ?? string.Empty;
            this.StartFrame = startFrame;
            this.EndFrame = endFrame;
        }

        //-----------------------------------------------------------------

        public string Name
        {
            get { return this.name; }
        }

        public uint StartFrame { get; private set; }

        public uint EndFrame { get; private set; }
    }
}
