﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// パケット受信をサポートする接続ポイントです。
    /// </summary>
    public class InputConnectionPoint : ConnectionPoint<OutputConnectionPoint>
    {
        private int receivedLength = 0;

        /// <summary>
        /// パケットを受信すると発生します。
        /// </summary>
        /// <param name="e">イベントデータを指定します。</param>
        protected override void OnPacketReceived(PacketEventArgs e)
        {
            Assertion.Argument.NotNull(e);
            Assertion.Argument.NotNull(e.Packet);

            this.receivedLength += e.Packet.Samples.Length;
            base.OnPacketReceived(e);
        }

        /// <summary>
        /// 受信したパケットの合計サイズを取得します。
        /// </summary>
        public int ReceivedLength
        {
            get { return this.receivedLength; }
        }
    }
}
