﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;

    internal class DomObjectSizeWriter : AddressWriter
    {
        private SizeType sizeType = SizeType.Size;
        private Type sizeValueType = null;

        public SizeType SizeType
        {
            get { return this.sizeType; }
            set { this.sizeType = value; }
        }

        public Type SizeValueType
        {
            get { return this.sizeValueType; }
            set { this.sizeValueType = value; }
        }

        private ulong Size
        {
            get
            {
                Assertion.Operation.True(this.Reference != null);
                return (this.sizeType == SizeType.Size) ?
                    this.Reference.Size : this.Reference.OffsetToNext;
            }
        }

        protected override object GetInitialValue(DomWriterContext context)
        {
            Assertion.Argument.NotNull(context);

            if (null == this.sizeValueType)
            {
                return Address.MaxValue;
            }

            if (typeof(Byte) == this.sizeValueType)
            {
                return Byte.MaxValue;
            }

            if (typeof(UInt16) == this.sizeValueType)
            {
                return UInt16.MaxValue;
            }

            if (typeof(UInt32) == this.sizeValueType)
            {
                return UInt32.MaxValue;
            }

            if (typeof(UInt64) == this.sizeValueType)
            {
                return UInt64.MaxValue;
            }

            throw new Exception("invalid SizeType");
        }

        protected override object GetValue(DomWriterContext context)
        {
            if (null == context) { throw new ArgumentNullException("context"); }

            if (null == this.Reference)
            {
                return GetInitialValue(context);
            }

            if (null == this.sizeValueType)
            {
                return context.CreateAddress(this.Size);
            }

            if (typeof(Byte) == this.sizeValueType)
            {
                return (Byte)this.Size;
            }

            if (typeof(UInt16) == this.sizeValueType)
            {
                return (UInt16)this.Size;
            }

            if (typeof(UInt32) == this.sizeValueType)
            {
                return (UInt32)this.Size;
            }

            if (typeof(UInt64) == this.sizeValueType)
            {
                return (UInt64)this.Size;
            }

            throw new Exception("invalid SizeType");
        }
    }
}
