﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;

    [AttributeUsage(AttributeTargets.Property, Inherited = false)]
    public class DomConvertToAttribute : DomCustomProcessorAttribute
    {
        private Type typeConverterType;

        public DomConvertToAttribute(Type typeConverterType)
            : base(typeof(DomObjectWriter))
        {
            Assertion.Argument.NotNull(typeConverterType);

            if (typeConverterType.IsAbstract)
            {
                throw new ArgumentException("valueConverterType must not be abstract.");
            }

            if (typeConverterType.GetInterface(typeof(ITypeConverter).Name)
                    != typeof(ITypeConverter))
            {
                throw new ArgumentException("valueConverterType must implement IValueConverter.");
            }

            this.typeConverterType = typeConverterType;
        }

        protected override IDomObjectProcessor CreateCustomProcessor()
        {
            return new DomObjectWriter(CreateTypeConverter());
        }

        private ITypeConverter CreateTypeConverter()
        {
            ITypeConverter converter =
                Activator.CreateInstance(this.typeConverterType) as ITypeConverter;

            if (!(converter.InputType.IsPrimitive || converter.InputType.IsEnum))
            {
                throw new Exception("internal error : input type must be primitive or enum.");
            }

            if (!(converter.OutputType.IsPrimitive || converter.OutputType.IsEnum))
            {
                throw new Exception("internal error : output type must be primitive or enum.");
            }

            return converter;
        }
    }
}
