﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System.IO;

    /// <summary>
    /// DOMツリーの各要素をバイナリ出力します。
    /// </summary>
    public class DomWriter : DomProcessor
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="writer">出力先のバイナリライタを指定します。</param>
        public DomWriter(BinaryWriter writer)
            : base(new DomWriterContext(writer))
        {
        }

        /// <summary>
        /// DOMコンテキストを取得します。
        /// </summary>
        public new DomWriterContext Context
        {
            get { return base.Context as DomWriterContext; }
        }
    }
}
