﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using System.Collections.Generic;

    public class DomContext : IDomContext
    {
        private LinkedList<DomObject> objectStack = new LinkedList<DomObject>();

        public event EventHandler<DomObjectEventArgs> ObjectProcessing;
        public event EventHandler<DomObjectEventArgs> ObjectProcessed;
        public event EventHandler ProcessCompleted;

        public DomElement RootElement { get; private set; }

        public DomElement CurrentElement
        {
            get
            {
                LinkedListNode<DomObject> node = this.objectStack.Last;

                while (null != node)
                {
                    if (node.Value is DomElement) { return node.Value as DomElement; }
                    node = node.Previous;
                }

                return null;
            }
        }

        public DomElementField CurrentElementField
        {
            get
            {
                if (this.objectStack.Last.Value is DomElementField)
                {
                    return this.objectStack.Last.Value as DomElementField;
                }

                return null;
            }
        }

        public void Push(DomObject domObject)
        {
            if (null == domObject) { throw new ArgumentNullException("domObject"); }

            if (0 == this.objectStack.Count)
            {
                if (!(domObject is DomElement))
                {
                    throw new Exception("internal error : root object must be DomElement.");
                }

                this.RootElement = domObject as DomElement;
            }

            this.objectStack.AddLast(domObject);

            this.OnObjectProcessing(new DomObjectEventArgs(domObject));
        }

        public void Pop()
        {
            if (0 == this.objectStack.Count) { return; }

            DomObject domObject = this.objectStack.Last.Value;
            this.objectStack.RemoveLast();

            this.OnObjectProcessed(new DomObjectEventArgs(domObject));

            if (0 == this.objectStack.Count)
            {
                this.OnProcessCompleted(EventArgs.Empty);
            }
        }

        protected virtual void OnObjectProcessing(DomObjectEventArgs e)
        {
            if (null == e) { throw new ArgumentNullException("e"); }

            if (null == this.ObjectProcessing) { return; }
            this.ObjectProcessing(this, e);
        }

        protected virtual void OnObjectProcessed(DomObjectEventArgs e)
        {
            if (null == e) { throw new ArgumentNullException("e"); }

            if (null == this.ObjectProcessed) { return; }
            this.ObjectProcessed(this, e);
        }

        protected virtual void OnProcessCompleted(EventArgs e)
        {
            if (null == e) { throw new ArgumentNullException("e"); }

            if (null == this.ProcessCompleted) { return; }
            this.ProcessCompleted(this, e);
        }
    }
}
