﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Reflection;

    public class DomElementField : DomObject
    {
        public DomElementField(object value)
            : base(value, false)
        {
            if (base.Value is DomElement)
            {
                base.DependedObject = base.Value as DomElement;
            }
        }

        public override object Value
        {
            get
            {
                // 値が DomElement の場合、リダイレクトします。
                return IsDepended ? (base.Value as DomElement).Value : base.Value;
            }
        }

        public override DomObjectCollection Children
        {
            get
            {
                // 値が DomElement の場合、リダイレクトします。
                return IsDepended ? (base.Value as DomElement).Children : base.Children;
            }
        }

        public new DomElement DependedObject
        {
            get
            {
                return IsDepended ? base.DependedObject as DomElement : null;
            }
        }
    }
}
