﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using NintendoWare.SoundAdditionalInfoConverter.Resources;

namespace NintendoWare.SoundAdditionalInfoConverter.Logs
{
    internal class Logger
    {
        private static Logger Instance = null;

        private Logger()
        {
        }

        internal static Logger GetInstance()
        {
            if (Instance == null)
            {
                Instance = new Logger();
            }

            return Instance;
        }

        internal bool IsSilent { get; set; }

        internal void OutputInformation(string text)
        {
            if (this.IsSilent)
            {
                return;
            }

            string header = Messages.MessageHeader_Information_General;
            Console.Out.WriteLine(header + text);
        }

        internal void OutputWarning(string text)
        {
            if (this.IsSilent)
            {
                return;
            }

            string header = Messages.MessageHeader_Warning_General;
            Console.Error.WriteLine(header + text);
        }

        internal void OutputError(string text)
        {
            string header = Messages.MessageHeader_Error_General;
            Console.Error.WriteLine(header + text);
        }
    }
}
